PSCAD 4.2.0

Settings
 {
 Id = "945729257.1118073484"
 Author = "reform.jayas"
 Desc = "C Interface Using Fortran 90"
 Arch = "windows"
 Options = 0
 Build = 1
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.01
  Step = 0.0001
  Plot = 0.0001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Component("test_Csub")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Integer
    }
   Output("out",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-36,0)
   Pen(,Solid)
   Line(-36,0,-42,6)
   Line(-36,0,-42,-6)
   Pen(,ByNode,,out)
   Line(54,0,36,0)
   Text(-1,19,"out=6*in")
   Pen(Black,Solid,0.2)
   Rectangle(-36,-29,36,28)
   Text(0,-15,"Calls C")
   Text(0,1,"\"Subroutine\"")
   }

  Section(EMTDC)
   {
   Fortran = "\
!
! ****** TEST_CSUB ******
!
       CALL AUX_CSUB($IN,$OUT)"
   Branch = ""
   Computations = ""
   }
  }
 Component("test_Cfun")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Integer
    }
   Output("out",54,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Rectangle(-36,-29,36,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-37,0)
   Pen(,Solid)
   Line(-36,0,-42,6)
   Line(-36,0,-42,-6)
   Pen(,ByNode,,out)
   Line(54,0,36,0)
   Text(0,19,"out=2*in")
   Text(0,-12,"Calls C")
   Text(0,3,"\"Function\"")
   }

  Section(EMTDC)
   {
   Fortran = "\
!
! ****** TEST_CFUN ******
!
       CALL AUX_CFUN($IN,$OUT)

     "
   Branch = ""
   Computations = ""
   }
  }
 Component("test_cblck_one")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Real
    }
   Output("out2",54,0)
    {
    Type = Integer
    }
   Output("out1",0,-54)
    {
    Type = Real
    }
   Output("out3",0,54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-36,-29,36,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-36,0)
   Pen(,Solid)
   Line(-36,0,-42,6)
   Line(-36,0,-42,-6)
   Pen(,ByNode)
   Line(54,0,36,0)
   Text(1,-13,"Call of C")
   Line(0,-30,0,-55)
   Line(0,54,0,29)
   Text(1,1,"\"subroutine\"")
   Text(1,19,"CBlck STOR ")
   }

  Section(EMTDC)
   {
   Fortran = "\
#STORAGE REAL:1 
#STORAGE INTEGER:1
#STORAGE STOR:1
      
      CALL AUX_CBLCK_ONE($IN)
      $OUT1=STORF(NSTORF)
      $OUT2=STORI(NSTORI)
      $OUT3=STOR(NEXC+1)
! indexes are updated here, but they
! can be updated also inside the Fortran
! subroutine or C procedure
      NSTORF=NSTORF+1
      NSTORI=NSTORI+1
      NEXC=NEXC+1"
   Branch = ""
   Computations = ""
   }
  }
 Component("test_cblck_two")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Data Entry")
    {
    Input("Res",10,8,156,12,2)
     {
     Desc = "Value of Resistance"
     Def = "1.0"
     Data = Real
     Unit = "ohm"
     Len = 15
     Min = 0
     }
    }
   }

  Nodes = 
   {
   Output("out",0,-54)
    {
    Type = Real
    }
   Electrical("A",-36,0)
    {
    Type = Removable
    }
   Electrical("B",36,0)
    {
    Type = Removable
    }
   }

  Graphics = 
   {
   Line(-18,0,-13,0)
   Line(-13,0,-11,5)
   Line(-11,5,-6,-5)
   Line(-6,-5,-2,5)
   Line(-2,5,2,-5)
   Line(2,-5,6,5)
   Line(6,5,11,-5)
   Line(11,-5,13,0)
   Line(13,0,18,0)
   Text(0,19,"$Res")
   Line(-16,-7,16,-7)
   Line(0,-31,0,-54)
   Text(0,-13,"Vltg (t-dt)")
   Line(-36,0,-18,0)
   Line(18,0,36,0)
   Rectangle(-28,-31,28,31)
   Line(-16,-7,-10,-9)
   Line(-16,-7,-10,-6)
   }

  Section(EMTDC)
   {
   Fortran = "\
      
      CALL AUX_CBLCK_TWO($BR,$SS,$OUT)
"
   Branch = "  BR = $A   $B   $Res  0  0"
   Computations = ""
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,48,[635,473],100)
   {
   -Sticky-([450,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,126,774,234
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
EXAMPLE 1:

A simple call of a C \"subroutine\".

A single INT parameter is passed as an argument into a procedure \"aux_Csub\", which calls a procedure \"test_Csub\" (written in C)."
    }
   -Sticky-([450,306],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,306,774,432
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
EXAMPLE 2:
  
A simple call of C \"function\".

A single INT parameter is passed as an argument into a procedure \"aux_Cfun\", which calls a C procedure  \"test_Cfun\""
    }
   -Sticky-([450,558],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,558,774,900
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
EXAMPLE 3:

A call of C \"subroutine\".

A simple example of usage of EMTDC 
STOR arrays:  STORF(:)
                          STORI(:)
                          STOR(:)
and pointers:  NSTORF
                          NSTORI
                          NEXC

Results:           out1 (REAL) 
                              -should be 0.5 
                              - uses STORF
                          out2 (INT) 
                              - should be 1
                              - uses STORI
                          out3 (REAL) 
                              - should be equal to 'input' 
                              - uses STOR
  "
    }
   -Sticky-([450,954],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,954,738,1206
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
EXAMPLE 4:

A call of C \"subroutine\".

A simple model of resistor with 
voltage across it as the output (the 
voltage is one dt delayed) and uses 
EMTDC matrixes:
          
VDC(n,ss) - voltage at node 'n' in subsystem 
                      'ss'
IEF(bn,ss) - FROM node of branch 'bn' in
                      subsystem 'ss'
IET(bn,ss) - TO node of branch 'bn' in 
                       subsystem 'ss'        
  "
    }
   -Sticky-([90,558],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 90,558,306,666
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
A Fortran file with the subroutines to all examples. These subroutines define the Fortran interface to the C procedures.

Double-click the icon to open the file."
    }
   0.const([1008,180],0,0,10)
    {
    Name = ""
    Value = "2"
    }
   0.pgb([1188,180],0,22680536,40)
    {
    Name = "out1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.unity([1080,180],0,0,20)
    {
    IType = "2"
    OType = "1"
    }
   0.const([1008,360],0,0,50)
    {
    Name = ""
    Value = "5"
    }
   0.unity([1080,360],0,0,60)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1188,360],0,22683064,80)
    {
    Name = "out2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([954,738],0,22684856,120)
    {
    Name = "out3_3"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "0.4"
    Max = "1.8"
    }
   0.pgb([1008,684],0,22686512,110)
    {
    Name = "out3_2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "0.4"
    Max = "1.8"
    }
   0.pgb([954,630],0,22688168,170)
    {
    Name = "out3_1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "0.4"
    Max = "1.8"
    }
   0.ground([810,1098],1,0,-1)
    {
    }
   0.source1([810,1062],7,0,-1)
    {
    Name = "Source1"
    Type = "1"
    Ctrl = "0"
    Vm = "1.00 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.0 [sec]"
    Imp = "0"
    ACDC = "0"
    Exph = "0"
    Term = "0"
    Es = "1.0 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "100.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "1.0 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = ""
    }
   -Wire-([810,1026],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1026],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.ground([1026,1098],1,0,-1)
    {
    }
   0.voltmetergnd([864,1026],0,0,130)
    {
    Name = "Ea"
    }
   0.datalabel([882,1134],0,0,-1)
    {
    Name = "Ea"
    }
   0.pgb([882,1134],0,22729576,150)
    {
    Name = "Ea"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "-0.6"
    Max = "0.8"
    }
   -Wire-([1026,1026],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Sticky-([18,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 18,72,414,324
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case contains four custom models which use procedures written in C. The case is meant to be used with Digital/Compaq/Intel Visual Fortran and Microsoft Visual C++.

When EMTDC is used with Digital/Compaq/Intel Visual Fortran, memory for matrices and arrays is allocated dynamically. Matrix/array sizes are stored in the array E_NDIM.

A value of  E_NDIM(x) is the equivalent of NDx.  A list of all important *.h files and additional information about writing custom components is included in the on-line help section:
EMTDC Manual: Writing Your Own Models
"
    }
   0.pgb([918,972],0,22733136,160)
    {
    Name = "Vltg (Ea delayed by deltT)"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Min = "-0.6"
    Max = "0.8"
    }
   0.annotation([198,396],0,0,-1)
    {
    AL1 = "FORTRAN FILE"
    AL2 = ""
    }
   0.annotation([198,702],0,0,-1)
    {
    AL1 = "C FILE"
    AL2 = ""
    }
   -SrcFile-([162,738],0)
    {
   Name = "CM_msc.c"
    }
   -Sticky-([108,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 108,864,288,954
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
A C file with the subroutines to all examples.

Double click the icon to open the file.
"
    }
   -SrcFile-([162,432],0)
    {
   Name = "CM_df90.f"
    }
   .test_Cfun([1134,360],0,0,70)
    {
    }
   .test_Csub([1134,180],0,0,30)
    {
    }
   -Wire-([882,684],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([846,684],0,0,90)
    {
    Name = ""
    Value = "1.75"
    }
   .test_cblck_one([954,684],0,0,100)
    {
    }
   -ControlPanel-([1386,306],0)
    {
    Name = "Example #2 Out"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Meter(22683064)
    }
   -ControlPanel-([1386,108],0)
    {
    Name = "Example #1 Out"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Meter(22680536)
    }
   -Plot-([1098,576],0)
    {
    Title = "Example #3 Out"
    Draw = 1
    Area = [0,0,396,234]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,396,234
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,396,171],"")
     {
     Options = 0
     Units = ""
     Curve(22688168,"out3_1",0,,,)
     Curve(22686512,"out3_2",1,,,)
     Curve(22684856,"out3_3",2,,,)
     }
    }
   -Plot-([1098,936],0)
    {
    Title = "Example #4 Out"
    Draw = 1
    Area = [0,0,396,234]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,396,234
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,396,171],"Voltage")
     {
     Options = 0
     Units = "kV"
     Curve(22729576,"Ea",0,,,)
     Curve(22733136,"Vltg (Ea delayed by deltT)",1,,,)
     }
    }
   .test_cblck_two([918,1026],0,0,140)
    {
    Res = "1.0 [ohm]"
    }
   -Sticky-([522,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 522,18,972,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "C INTERFACE USING FORTRAN 90"
    }
   }
  }
 }

